/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.awt.Image;
import javax.swing.Icon;
import org.netbeans.modules.refactoring.java.Bundle;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.FiltersManager;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedBinaryElement
extends SimpleRefactoringElementImplementation
implements FiltersManager.Filterable {
    private final String htmlText;
    private final String elementText;
    private final FileObject fo;
    private final boolean fromTest;
    private final boolean fromPlatform;

    private WhereUsedBinaryElement(FileObject fo, boolean inTest, boolean inPlatform) {
        String name = fo.getNameExt();
        this.htmlText = "<b>" + name + "</b>";
        this.elementText = name;
        this.fromTest = inTest;
        this.fromPlatform = inPlatform;
        this.fo = fo;
    }

    public String getDisplayText() {
        return this.htmlText;
    }

    public Lookup getLookup() {
        Icon icon = null;
        try {
            icon = ImageUtilities.image2Icon((Image)DataObject.find((FileObject)this.fo).getNodeDelegate().getIcon(1));
            Boolean inTestFile = ElementGripFactory.getDefault().inTestFile(this.fo);
            if (Boolean.TRUE == inTestFile) {
                icon = ImageUtilities.mergeIcons((Icon)icon, (Icon)ImageUtilities.loadIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_test.png"), (int)4, (int)4);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return icon != null ? Lookups.fixed((Object[])new Object[]{icon, this.fo.getParent()}) : Lookups.fixed((Object[])new Object[]{this.fo.getParent()});
    }

    public PositionBounds getPosition() {
        return null;
    }

    public String getText() {
        return this.elementText;
    }

    public void performChange() {
    }

    public void openInEditor() {
        if (this.fo == null || !this.fo.isValid()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.WARN_ElementNotFound());
        } else {
            try {
                DataObject od = DataObject.find((FileObject)this.fo);
                NbDocument.openDocument((Lookup.Provider)od, (int)0, (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public FileObject getParentFile() {
        return this.fo.getParent();
    }

    public static WhereUsedBinaryElement create(FileObject fo, boolean fromTest, boolean fromPlatform) {
        return new WhereUsedBinaryElement(fo, fromTest, fromPlatform);
    }

    public boolean filter(FiltersManager manager) {
        boolean show = true;
        if (JavaWhereUsedQueryPlugin.DEPENDENCIES) {
            if (this.fromPlatform) {
                show = show && manager.isSelected(JavaWhereUsedFilters.PLATFORM.getKey());
            } else {
                boolean bl = show = show && manager.isSelected(JavaWhereUsedFilters.DEPENDENCY.getKey());
            }
        }
        if (this.fromTest) {
            boolean bl = show = show && manager.isSelected(JavaWhereUsedFilters.TESTFILE.getKey());
        }
        if (JavaWhereUsedQueryPlugin.DEPENDENCIES) {
            show = show && manager.isSelected(JavaWhereUsedFilters.BINARYFILE.getKey());
        }
        return show;
    }
}

